const { Telegraf } = require("telegraf");
require("dotenv").config();

const providerToken = process.env.PROVIDER_TOKEN; // токен выданный через бот @SberbankPaymentBot
const currency = "BYN"; // Трехбуквенный код валюты ISO 4217, BYN для ABBY
const startParameter = "get_access";

const capitalizeFirstLetter = ([first, ...rest]) => {
  return first.toLocaleUpperCase("RU") + rest.join("");
};

const bot = new Telegraf(process.env.BOT_TOKEN); //сюда помещается токен, который дал botFather

const prepareArrayOfTextMessages = (arrayOfTextMessages) => {
  let _preparedArrayOfTextMessages = [];

  arrayOfTextMessages.forEach((textMessage, index) => {
    _preparedArrayOfTextMessages = _preparedArrayOfTextMessages.concat([
      textMessage,
      textMessage.toLowerCase(),
      capitalizeFirstLetter(textMessage),
      textMessage.toUpperCase(),
    ]);

    return index;
  });

  return _preparedArrayOfTextMessages;
};
const payMatchingTextMessages = [
  "/invoice",
  "Invoice",
  "Pay",
  "Оплатить",
  "Pay by cash",
];
const paySuccesMessage = "👌 Оплата прошла";
const invoiceTitle = "Название продукта"; // Название продукта, 1-32 символа
const invoiceDescription = `Описание услуги и/или товара. Желательно длинное.`; // Описание продукта, 1-255 знаков

const helpHandler = (ctx) => {
  return ctx.reply(
    `
    Для проведения тестовой оплаты:
      1. Отправить /invoice для получения счета на оплату
      2. Нажать кнопку "Заплатить 123,99 BYN" 
      3. Нажать кнопку "Способы оплаты"
      4. Нажать кнопку "Оплатить"
      5. Ввести тестовые карточные данные
      6. Нажать кнопку "Перейти к оплате"
      7. Нажать кнопку "Оплатить"
      8. На странице ACS ввести код 12345678
      9. В случае успеха — "${paySuccesMessage}"` +
      `\n\nТестовые карточные данные
      Номер карты: 4111 1111 1111 1111
      Срок действия: 12/24
      CVC: 123
  `
  );
};

const payHandler = (ctx) => {
  const invoice = getInvoice(ctx);

  return ctx.replyWithInvoice(invoice);
};

const getInvoice = (ctx) => {
  const chat_id = ctx.from.id;
  const invoice = {
    chat_id, // Уникальный идентификатор целевого чата или имя пользователя целевого канала
    provider_token: providerToken,
    photo_url: 'https://via.placeholder.com/400',
    photo_width: 200,
    photo_height: 200,
    start_parameter: startParameter, // Уникальный параметр глубинных ссылок. Если оставить поле пустым, переадресованные копии отправленного сообщения будут иметь кнопку «Оплатить», позволяющую нескольким пользователям производить оплату непосредственно из пересылаемого сообщения, используя один и тот же счет. Если не пусто, перенаправленные копии отправленного сообщения будут иметь кнопку URL с глубокой ссылкой на бота (вместо кнопки оплаты) со значением, используемым в качестве начального параметра.
    title: invoiceTitle,
    description: invoiceDescription,
    currency: "BYN",
    prices: [
      { label: "Кефир", amount: 6099 },
      { label: "Молоко", amount: 6300 },
    ],
    //max_tip_amount: 1300,
    //suggested_tip_amounts: [222, 444, 888],
    payload: {
      // Полезные данные счета-фактуры, определенные ботом, 1–128 байт. Это не будет отображаться пользователю, используйте его для своих внутренних процессов.
      providerToken,
    },
  };

  return invoice;
};

bot.use(Telegraf.log());

bot.hears(["/start", "/help", `/start ${startParameter}`], helpHandler);
bot.hears(prepareArrayOfTextMessages(payMatchingTextMessages), payHandler);

const preCheckOutHandler = (ctx) => {
  return ctx.answerPreCheckoutQuery(true);
}

// Ответ на предварительный запрос по оплате
bot.on("pre_checkout_query", preCheckOutHandler);

bot.on("successful_payment", async (ctx) => {
  // ответ в случае положительной оплаты
  await ctx.reply(paySuccesMessage);
});

bot.launch();
