"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const safeCompare = require("safe-compare");
const debug = debug_1.default('telegraf:webhook');
function default_1(hookPath, updateHandler) {
    return async (req, res, next = () => {
        res.statusCode = 403;
        debug('Replying with status code', res.statusCode);
        return res.end();
    }) => {
        debug('Incoming request', req.method, req.url);
        if (req.method !== 'POST' || !safeCompare(hookPath, req.url)) {
            return next();
        }
        let update;
        if (req.body != null) {
            update = req.body;
            await updateHandler(update, res);
            return;
        }
        let body = '';
        for await (const chunk of req) {
            body += String(chunk);
        }
        try {
            update = JSON.parse(body);
        }
        catch (error) {
            res.writeHead(415);
            res.end();
            debug('Failed to parse request body:', error);
            return;
        }
        await updateHandler(update, res);
    };
}
exports.default = default_1;
