/** @format */
import { Message, Opts, Telegram, Update } from './core/types/typegram';
import { UnionKeys } from './deunionize';
export { Markup } from './markup';
export declare type ChatAction = Opts<'sendChatAction'>['action'];
/**
 * Create an `Extra*` type from the arguments of a given method `M extends keyof Telegram` but `Omit`ting fields with key `K` from it.
 *
 * Note that `chat_id` may not be specified in `K` because it is `Omit`ted by default.
 */
declare type MakeExtra<M extends keyof Telegram, K extends keyof Omit<Opts<M>, 'chat_id'> = never> = Omit<Opts<M>, 'chat_id' | K>;
export declare type ExtraAddStickerToSet = MakeExtra<'addStickerToSet', 'name' | 'user_id'>;
export declare type ExtraAnimation = MakeExtra<'sendAnimation', 'animation'>;
export declare type ExtraAnswerCbQuery = MakeExtra<'answerCallbackQuery', 'text' | 'callback_query_id'>;
export declare type ExtraAnswerInlineQuery = MakeExtra<'answerInlineQuery', 'inline_query_id' | 'results'>;
export declare type ExtraAudio = MakeExtra<'sendAudio', 'audio'>;
export declare type ExtraContact = MakeExtra<'sendContact', 'phone_number' | 'first_name'>;
export declare type ExtraCopyMessage = MakeExtra<'copyMessage', 'from_chat_id' | 'message_id'>;
export declare type ExtraCreateChatInviteLink = MakeExtra<'createChatInviteLink'>;
export declare type ExtraCreateNewStickerSet = MakeExtra<'createNewStickerSet', 'name' | 'title' | 'user_id'>;
export declare type ExtraDice = MakeExtra<'sendDice'>;
export declare type ExtraDocument = MakeExtra<'sendDocument', 'document'>;
export declare type ExtraEditChatInviteLink = MakeExtra<'editChatInviteLink', 'invite_link'>;
export declare type ExtraEditMessageCaption = MakeExtra<'editMessageCaption', 'message_id' | 'inline_message_id' | 'caption'>;
export declare type ExtraEditMessageLiveLocation = MakeExtra<'editMessageLiveLocation', 'message_id' | 'inline_message_id' | 'latitude' | 'longitude'>;
export declare type ExtraEditMessageMedia = MakeExtra<'editMessageMedia', 'message_id' | 'inline_message_id' | 'media'>;
export declare type ExtraEditMessageText = MakeExtra<'editMessageText', 'message_id' | 'inline_message_id' | 'text'>;
export declare type ExtraGame = MakeExtra<'sendGame', 'game_short_name'>;
export declare type NewInvoiceParameters = MakeExtra<'sendInvoice', 'disable_notification' | 'reply_to_message_id' | 'allow_sending_without_reply' | 'reply_markup'>;
export declare type ExtraInvoice = MakeExtra<'sendInvoice', keyof NewInvoiceParameters>;
export declare type ExtraKickChatMember = MakeExtra<'kickChatMember', 'user_id' | 'until_date'>;
export declare type ExtraLocation = MakeExtra<'sendLocation', 'latitude' | 'longitude'>;
export declare type ExtraMediaGroup = MakeExtra<'sendMediaGroup', 'media'>;
export declare type ExtraPhoto = MakeExtra<'sendPhoto', 'photo'>;
export declare type ExtraPoll = MakeExtra<'sendPoll', 'question' | 'options' | 'type'>;
export declare type ExtraPromoteChatMember = MakeExtra<'promoteChatMember', 'user_id'>;
export declare type ExtraReplyMessage = MakeExtra<'sendMessage', 'text'>;
export declare type ExtraRestrictChatMember = MakeExtra<'restrictChatMember', 'user_id'>;
export declare type ExtraSetMyCommands = MakeExtra<'setMyCommands', 'commands'>;
export declare type ExtraSetWebhook = MakeExtra<'setWebhook', 'url'>;
export declare type ExtraSticker = MakeExtra<'sendSticker', 'sticker'>;
export declare type ExtraStopPoll = MakeExtra<'stopPoll', 'message_id'>;
export declare type ExtraVenue = MakeExtra<'sendVenue', 'latitude' | 'longitude' | 'title' | 'address'>;
export declare type ExtraVideo = MakeExtra<'sendVideo', 'video'>;
export declare type ExtraVideoNote = MakeExtra<'sendVideoNote', 'video_note'>;
export declare type ExtraVoice = MakeExtra<'sendVoice', 'voice'>;
/** Possible update types */
export declare type UpdateType = Exclude<UnionKeys<Update>, keyof Update>;
/** Possible message subtypes. Same as the properties on a message object */
export declare type MessageSubType = 'forward_date' | Exclude<UnionKeys<Message>, keyof Message.CaptionableMessage | 'entities' | 'media_group_id'>;
declare type ExtractPartial<T extends object, U extends object> = T extends unknown ? Required<T> extends U ? T : never : never;
/**
 * Maps [[`Composer.on`]]'s `updateType` or `messageSubType` to a `tt.Update` subtype.
 */
export declare type MountMap = {
    [T in UpdateType]: Extract<Update, Record<T, object>>;
} & {
    [T in MessageSubType]: {
        message: ExtractPartial<Update.MessageUpdate['message'], Record<T, unknown>>;
        update_id: number;
    };
};
//# sourceMappingURL=telegram-types.d.ts.map